import dynamic from "next/dynamic";
// Dynamically import components
import { blogdata as blogs } from "@/data/data";
import { domain } from "@/app/domain";
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const BlogSchema = dynamic(() => import("@/components/Schema/BlogSchema"));
const BlogHero = dynamic(() => import("@/sections/BlogHero"));
const BlogList = dynamic(() => import("@/sections/BlogList"));
// Generate static params for dynamic routes
export async function generateStaticParams() {
  return blogs.blog_detail.map((blog) => ({
    blog_slug: blog.slug,
  }));
}

// Generate metadata dynamically based on the blog_slug
export async function generateMetadata({ params }) {
  const { blog_slug } = params;

  // Find the specific blog based on the slug
  const blog = blogs.blog_detail.find((blog) => blog.slug === blog_slug);

  // Return dynamic metadata
  if (blog) {
    return {
      metadataBase: new URL(`https://${domain}`),
      title: blog.title,
      description: blog.description,
      keywords: blog.keywords,
      alternates: {
        canonical: `/blog/${blog.slug}`,
      },
      openGraph: {
        type: "website",
        siteName: "Palm Jebel Ali",
        url: `/blog/${blog.slug}`,
        images: {
          url: "/images/bhariabac.jpeg",
          width: 100,
          height: 100,
        },
      },
    };
  }

  return {
    title: "Blog Not Found",
    description: "The requested blog page could not be found.",
  };
}

// Dynamic page for each blog
export default function PostPage({ params }) {
  const { blog_slug } = params;

  // Find the specific blog based on the slug
  const blog = blogs.blog_detail.find((blog) => blog.slug === blog_slug);

  if (!blog) {
    return <div>Post not found</div>;
  }
  return (
    <>
      <WebsiteSchema
        title={blog.title}
        description={blog.description}
        keywords={blog.keywords}
        fullUrl={`https://${domain}/blog/${blog.slug}`}
      />
      <RatingSchema title={blog.title} />
      <BlogSchema
        title={blog.title}
        img={blog.img}
        url={`https://${domain}`}
        blogurl={`https://${domain}/blog/${blog.slug}`}
      />
      <BlogHero headingBlog={blog?.title} img={blog?.img} />
      <BlogList data={blog} />
    </>
  );
}
